TITLE   'Glass Ball in a Parallel Field'			         { exa103.pde }
SELECT     errlim=3e-6     ngrid=1     spectral_colors
COORDINATES   ycylinder( 'r', 'z')
VARIABLES   U
DEFINITIONS
   Lz=1.0     Lr=2*Lz     r0=0.05     rad=sqrt(r^2+z^2)
   eps0=8.854e-12     epsr1=1.0     epsr2=7.0
   epsr     eps=epsr*eps0     U0=1.0     U_ex 	{ Declared only }
   E0=-2*U0/(2*Lz)     De0=eps0*E0	  		{ Far field }
   E=-grad(U)     Em=magnitude(E)     D=eps*E     Dm=magnitude(D)
Dm_ex0=abs[ eps0*epsr2*3/(2+epsr2)*E0]		{ Dm inside ball }
EQUATIONS
   div( D)=0					{ Expanded automatically for (r,z) }	
BOUNDARIES
region 'domain' epsr=epsr1     				{ Vacuum }
   U_ex=-[1+(1-epsr2)/(2+epsr2)*( r0/rad)^3]*E0*z	{ Analytic 1 }
   start 'outer' (0,-Lz)   value(U)= -U0 line to (Lr,-Lz)
   natural(U)=0   line to (Lr,Lz)
   value(U)=U0   line to (0,Lz)
   natural(U)=0   line to close
region 'glass'  epsr=epsr2   					{ Glass }	
   U_ex=-3/(2+epsr2)*E0*z		{ Analytic solution, yields Dm_ex0 }
   start (0,r0) line to (0,-r0)  arc to (r0,0) close
feature  start  'circle'  (0,-r0) arc to (r0,0) to (0,r0)
PLOTS
   contour( U)     contour( U-U_ex) painted     elevation( U) on 'outer'
   elevation( normal( D)) on 'outer' report( De0)
   vector( D) norm     vector( D) on 'glass' report(Dm_ex0)
   elevation( normal(D), tangential(D)) on 'circle' on 'glass'
   elevation( -normal(D), -tangential(D)) on 'circle' on 'domain'
END

